package gov.va.vamf.scheduling.direct.datalayer.clinic;

import com.agilex.healthcare.directscheduling.dao.DAOConstants;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.object.StoredProcedure;

import java.sql.Types;
import java.util.Map;

public class ClinicStoredProcedure extends StoredProcedure {

	public ClinicStoredProcedure(JdbcTemplate jdbcTemplate, String storedProcedureString,
								 ClinicResultSetRowMapper clinicResultSetRowMapper) {

		super(jdbcTemplate, storedProcedureString);

		declareParameter(new SqlReturnResultSet(DAOConstants.RESULT_LIST, clinicResultSetRowMapper));

		declareParameter(new SqlParameter(DAOConstants.STATION, Types.VARCHAR));
		declareParameter(new SqlParameter(DAOConstants.STOP_CODE_PAIRS, Types.VARCHAR));
		declareParameter(new SqlParameter(DAOConstants.DISP_APPT_FLAG, Types.VARCHAR));
		declareParameter(new SqlParameter(DAOConstants.DIRECT_SCHED_FLAG, Types.VARCHAR));
        declareParameter(new SqlParameter(DAOConstants.CLINIC_IENS, Types.VARCHAR));

		compile();
	}

	public Map<String, Object> getStoredProcedureResults(Map<String, Object> inParameters) {
		return execute(inParameters);
	}
}
